﻿Public Class SmokePlumeParticleSystem
    Inherits ParticleSystem

    Sub New(g As Game, howManyEffects As Integer, r As Random, spriteBatch As SpriteBatch, world As VirtualWorld)
        MyBase.New(g, howManyEffects, r, spriteBatch, world)
    End Sub

    Protected Overrides Sub InitializeConstants()
        TextureFileName = "Textures/Smoke"

        MinInitialSpeed = 20
        MaxInitialSpeed = 100

        ' we don't want the particles to accelerate at all, aside from what we
        ' do in our overriden InitializeParticle.
        MinAcceleration = 0
        MaxAcceleration = 0

        ' long lifetime, this can be changed to create thinner or thicker smoke.
        ' tweak minNumParticles and maxNumParticles to complement the effect.
        MinLifeTime = 5.0F
        MaxLifeTime = 7.0F

        MinScale = 0.5F
        MaxScale = 1.0F

        ' we need to reduce the number of particles on Windows Phone in order to keep
        ' a good framerate
        Me.MinNumberParticles = 7
        Me.MaxNumberParticles = 15


        ' rotate slowly, we want a fairly relaxed effect
        MinRotationSpeed = -MathHelper.PiOver4 / 2.0F
        MaxRotationSpeed = MathHelper.PiOver4 / 2.0F

        BlendState = BlendState.AlphaBlend

        DrawOrder = AlphaBlendDrawOrder
    End Sub

    Protected Overrides Function PickRandomDirection() As Microsoft.Xna.Framework.Vector2
        'point the particles somewhere between 80 and 100 degrees
        'tweak this to make the smoke have more oe less spread
        Dim radians As Single = Me.World.RandomBetween(MathHelper.ToRadians(80), MathHelper.ToRadians(100))
        Dim direction As Vector2 = Vector2.Zero
        direction.X = CSng(Math.Cos(radians))
        direction.Y = -CSng(Math.Sin(radians))
        Return direction
    End Function

    Protected Overrides Sub InitializeParticle(p As Particle, where As Microsoft.Xna.Framework.Vector2)
        MyBase.InitializeParticle(p, where)
        p.Acceleration.X += Me.World.RandomBetween(10, 50)
    End Sub
End Class
